/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.lockmgr;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.HscIdUtils;
import com.ibm.hsc.common.util.HscPrintStream;
import com.ibm.hsc.common.util.HscResourceId;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50PCISlot;
import com.ibm.hsc.rep.v50.R50SNIAdapter;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt32;

public class FspReqRecord {
    private HscResourceId mResId;
    private int mLockType;
    private byte[] mResBuf = null;
    public static final int NON_PERSISTENT_READ = 0;
    public static final int NON_PERSISTENT_WRITE = 64;
    public static final int PERSISTENT_READ = 128;
    public static final int PERSISTENT_WRITE = 192;
    private static final int[] SUPPORTED_CLS_IDS = new int[]{R50Define.CID_IBMHSC_ComputerSystem, R50Define.CID_IBMHSC_Partition, R50Define.CID_IBMHSC_PCISlot, R50Define.CID_IBMHSC_VirtualSCSI, R50Define.CID_IBMHSC_VirtualSerial, R50Define.CID_IBMHSC_VirtualEthernet, R50Define.CID_IBMHSC_SNIAdapter};
    private static final int[][] RES_MAPPINGS = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, -1, 14, 16, 17, 18, 19}, {9, -1, -1, -1, -1, -1, -1, -1, 10, 11, -1, -1, -1, -1, -1}, {12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    private static final byte[][] RESIDS = new byte[][]{{2, 4, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 4, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0, 0}, {2, 9, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {3, 0, -80, 0, 1, 7, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 1, 8, 0, 0, 0, 0, 0, 0}, {3, 1, 64, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {3, 1, 0, 0, 1, 0, 0, 8, 0, 0, 0, 0}, {3, 1, -112, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {4, 0, 52, 0, 1, 7, 0, 0, 0, 0, 0, 0}, {4, 1, 20, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {2, 11, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {3, 3, 64, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 2, 3, 0, 0, 0, 0, 0, 0}, {2, 0, 0, 0, 2, 4, 0, 0, 0, 0, 0, 0}};

    public FspReqRecord(HscResourceId hscResourceId, int n) {
        this.mResId = hscResourceId;
        this.mLockType = n;
        System.out.println("lockType: " + n);
    }

    void setLockType(int n) {
        this.mLockType = n;
    }

    public void getFspReqRecord(byte[] byArray, int n) {
        n += 4;
        if (this.mResBuf == null) {
            try {
                RObjectId rObjectId = HscIdUtils.getInstance().createRObjectId(this.mResId);
                this.mResBuf = new byte[RESIDS[0].length];
                int n2 = rObjectId.getClassId();
                for (int i = 0; i < SUPPORTED_CLS_IDS.length; ++i) {
                    if (n2 != SUPPORTED_CLS_IDS[i]) continue;
                    int n3 = RES_MAPPINGS[i][this.mResId.getCategory()];
                    System.out.println("ndx " + n3);
                    System.arraycopy(RESIDS[n3], 0, this.mResBuf, 0, this.mResBuf.length);
                    if (n2 == R50Define.CID_IBMHSC_Partition) {
                        this.fillPartitionId(this.mResBuf, 5, rObjectId);
                    } else if (n2 == R50Define.CID_IBMHSC_PCISlot) {
                        this.fillIoSlotId(this.mResBuf, 6, rObjectId);
                    } else if (n2 == R50Define.CID_IBMHSC_VirtualSCSI) {
                        this.fillVirScsiId(this.mResBuf, 7, rObjectId);
                    } else if (n2 == R50Define.CID_IBMHSC_VirtualSerial) {
                        this.fillVirSerialId(this.mResBuf, 7, rObjectId);
                    } else if (n2 == R50Define.CID_IBMHSC_VirtualEthernet) {
                        this.fillVirEthernetId(this.mResBuf, 7, rObjectId);
                    } else if (n2 == R50Define.CID_IBMHSC_SNIAdapter) {
                        this.fillSniId(this.mResBuf, 5, rObjectId);
                    }
                    break;
                }
            }
            catch (RException rException) {
                rException.printStackTrace();
            }
        }
        System.arraycopy(this.mResBuf, 0, byArray, n, this.mResBuf.length);
        int n4 = n;
        byArray[n4] = (byte)(byArray[n4] & 0xF);
        int n5 = n;
        byArray[n5] = (byte)(byArray[n5] | (byte)this.mLockType);
        System.out.println("mLockType: " + this.mLockType);
        System.out.println("buf[" + n + "] = " + byArray[n]);
    }

    private void fillPartitionId(byte[] byArray, int n, RObjectId rObjectId) throws RException {
        String string = (String)rObjectId.getKeyValue(0);
        String string2 = string.substring(0, string.indexOf("*"));
        int n2 = Integer.parseInt(string2);
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    private void fillSniId(byte[] byArray, int n, RObjectId rObjectId) throws RException {
        RObject rObject = rObjectId.getObject();
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)rObject.getProperty(R50SNIAdapter.Index_DeviceID);
        HardwareServerMessage.intToBytes(unsignedInt32.intValue(), byArray, n);
    }

    private void fillIoSlotId(byte[] byArray, int n, RObjectId rObjectId) throws RException {
        RObject rObject = rObjectId.getObject();
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)rObject.getProperty(R50PCISlot.Index_DeviceID);
        HardwareServerMessage.intToBytes(unsignedInt32.intValue(), byArray, n);
    }

    private void fillVirScsiId(byte[] byArray, int n, RObjectId rObjectId) throws RException {
        String string = (String)rObjectId.getKeyValue(1);
        int n2 = Integer.parseInt(string);
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
        RObject rObject = rObjectId.getObject();
        Vector vector = rObject.associatorNames(R50Define.AID_IBMHSC_LparVirtualSCSI);
        this.fillPartitionId(byArray, n - 2, (RObjectId)vector.elementAt(0));
    }

    private void fillVirSerialId(byte[] byArray, int n, RObjectId rObjectId) throws RException {
        String string = (String)rObjectId.getKeyValue(1);
        int n2 = Integer.parseInt(string);
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
        RObject rObject = rObjectId.getObject();
        Vector vector = rObject.associatorNames(R50Define.AID_IBMHSC_LparVirtualSerial);
        this.fillPartitionId(byArray, n - 2, (RObjectId)vector.elementAt(0));
    }

    private void fillVirEthernetId(byte[] byArray, int n, RObjectId rObjectId) throws RException {
        String string = (String)rObjectId.getKeyValue(1);
        int n2 = Integer.parseInt(string);
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
        RObject rObject = rObjectId.getObject();
        Vector vector = rObject.associatorNames(R50Define.AID_IBMHSC_LparVirtualEthernet);
        this.fillPartitionId(byArray, n - 2, (RObjectId)vector.elementAt(0));
    }

    public String toString() {
        if (HscPrintStream.isTraceActive()) {
            return "\nmResId " + this.mResId + "\nmLockType " + this.mLockType + "\nmResBuf" + new HexDump(this.mResBuf) + "";
        }
        return "";
    }

    boolean containsRes(HscResourceId hscResourceId) {
        return hscResourceId.equals(this.mResId);
    }
}

